/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef EXTENSIONS_HELPIDS_H
#define EXTENSIONS_HELPIDS_H

#define HID_ABSPILOT_PREVIOUS                           "EXTENSIONS_HID_ABSPILOT_PREVIOUS"
#define HID_ABSPILOT_NEXT                               "EXTENSIONS_HID_ABSPILOT_NEXT"
#define HID_ABSPILOT_CANCEL                             "EXTENSIONS_HID_ABSPILOT_CANCEL"
#define HID_ABSPILOT_FINISH                             "EXTENSIONS_HID_ABSPILOT_FINISH"
#define UID_ABSPILOT_HELP                               "EXTENSIONS_UID_ABSPILOT_HELP"
#define HID_ABSPILOT                                    "EXTENSIONS_HID_ABSPILOT"

#define HID_BIB_IDENTIFIER_POS                          "EXTENSIONS_HID_BIB_IDENTIFIER_POS"
#define HID_BIB_AUTHORITYTYPE_POS                       "EXTENSIONS_HID_BIB_AUTHORITYTYPE_POS"
#define HID_BIB_AUTHOR_POS                              "EXTENSIONS_HID_BIB_AUTHOR_POS"
#define HID_BIB_TITLE_POS                               "EXTENSIONS_HID_BIB_TITLE_POS"
#define HID_BIB_YEAR_POS                                "EXTENSIONS_HID_BIB_YEAR_POS"
#define HID_BIB_ISBN_POS                                "EXTENSIONS_HID_BIB_ISBN_POS"
#define HID_BIB_BOOKTITLE_POS                           "EXTENSIONS_HID_BIB_BOOKTITLE_POS"
#define HID_BIB_CHAPTER_POS                             "EXTENSIONS_HID_BIB_CHAPTER_POS"
#define HID_BIB_EDITION_POS                             "EXTENSIONS_HID_BIB_EDITION_POS"
#define HID_BIB_EDITOR_POS                              "EXTENSIONS_HID_BIB_EDITOR_POS"
#define HID_BIB_HOWPUBLISHED_POS                        "EXTENSIONS_HID_BIB_HOWPUBLISHED_POS"
#define HID_BIB_INSTITUTION_POS                         "EXTENSIONS_HID_BIB_INSTITUTION_POS"
#define HID_BIB_JOURNAL_POS                             "EXTENSIONS_HID_BIB_JOURNAL_POS"
#define HID_BIB_MONTH_POS                               "EXTENSIONS_HID_BIB_MONTH_POS"
#define HID_BIB_NOTE_POS                                "EXTENSIONS_HID_BIB_NOTE_POS"
#define HID_BIB_ANNOTE_POS                              "EXTENSIONS_HID_BIB_ANNOTE_POS"
#define HID_BIB_NUMBER_POS                              "EXTENSIONS_HID_BIB_NUMBER_POS"
#define HID_BIB_ORGANIZATIONS_POS                       "EXTENSIONS_HID_BIB_ORGANIZATIONS_POS"
#define HID_BIB_PAGES_POS                               "EXTENSIONS_HID_BIB_PAGES_POS"
#define HID_BIB_PUBLISHER_POS                           "EXTENSIONS_HID_BIB_PUBLISHER_POS"
#define HID_BIB_ADDRESS_POS                             "EXTENSIONS_HID_BIB_ADDRESS_POS"
#define HID_BIB_SCHOOL_POS                              "EXTENSIONS_HID_BIB_SCHOOL_POS"
#define HID_BIB_SERIES_POS                              "EXTENSIONS_HID_BIB_SERIES_POS"
#define HID_BIB_REPORTTYPE_POS                          "EXTENSIONS_HID_BIB_REPORTTYPE_POS"
#define HID_BIB_VOLUME_POS                              "EXTENSIONS_HID_BIB_VOLUME_POS"
#define HID_BIB_URL_POS                                 "EXTENSIONS_HID_BIB_URL_POS"
#define HID_BIB_CUSTOM1_POS                             "EXTENSIONS_HID_BIB_CUSTOM1_POS"
#define HID_BIB_CUSTOM2_POS                             "EXTENSIONS_HID_BIB_CUSTOM2_POS"
#define HID_BIB_CUSTOM3_POS                             "EXTENSIONS_HID_BIB_CUSTOM3_POS"
#define HID_BIB_CUSTOM4_POS                             "EXTENSIONS_HID_BIB_CUSTOM4_POS"
#define HID_BIB_CUSTOM5_POS                             "EXTENSIONS_HID_BIB_CUSTOM5_POS"
#define HID_BIB_DB_GRIDCTRL                             "EXTENSIONS_HID_BIB_DB_GRIDCTRL"

#define HID_GROUPWIZARD_PREVIOUS                        "EXTENSIONS_HID_GROUPWIZARD_PREVIOUS"
#define HID_GROUPWIZARD_NEXT                            "EXTENSIONS_HID_GROUPWIZARD_NEXT"
#define HID_GROUPWIZARD_CANCEL                          "EXTENSIONS_HID_GROUPWIZARD_CANCEL"
#define HID_GROUPWIZARD_FINISH                          "EXTENSIONS_HID_GROUPWIZARD_FINISH"
#define HID_LISTWIZARD_PREVIOUS                         "EXTENSIONS_HID_LISTWIZARD_PREVIOUS"
#define HID_LISTWIZARD_NEXT                             "EXTENSIONS_HID_LISTWIZARD_NEXT"
#define HID_LISTWIZARD_CANCEL                           "EXTENSIONS_HID_LISTWIZARD_CANCEL"
#define HID_LISTWIZARD_FINISH                           "EXTENSIONS_HID_LISTWIZARD_FINISH"
#define HID_GRIDWIZARD_PREVIOUS                         "EXTENSIONS_HID_GRIDWIZARD_PREVIOUS"
#define HID_GRIDWIZARD_NEXT                             "EXTENSIONS_HID_GRIDWIZARD_NEXT"
#define HID_GRIDWIZARD_CANCEL                           "EXTENSIONS_HID_GRIDWIZARD_CANCEL"
#define HID_GRIDWIZARD_FINISH                           "EXTENSIONS_HID_GRIDWIZARD_FINISH"

#define HID_PROP_INPUT_REQUIRED                         "EXTENSIONS_HID_PROP_INPUT_REQUIRED"
#define HID_PROP_GROUPBOX                               "EXTENSIONS_HID_PROP_GROUPBOX"
#define HID_PROP_CONTROLSOURCE                          "EXTENSIONS_HID_PROP_CONTROLSOURCE"
#define HID_PROP_NAME                                   "EXTENSIONS_HID_PROP_NAME"
#define HID_PROP_TABINDEX                               "EXTENSIONS_HID_PROP_TABINDEX"
#define HID_PROP_MASTERFIELDS                           "EXTENSIONS_HID_PROP_MASTERFIELDS"
#define HID_PROP_SLAVEFIELDS                            "EXTENSIONS_HID_PROP_SLAVEFIELDS"
#define HID_PROP_DATASOURCE                             "EXTENSIONS_HID_PROP_DATASOURCE"
#define HID_PROP_CURSORSOURCE                           "EXTENSIONS_HID_PROP_CURSORSOURCE"
#define HID_PROP_CURSORSOURCETYPE                       "EXTENSIONS_HID_PROP_CURSORSOURCETYPE"
#define HID_PROP_CURSORTYPE                             "EXTENSIONS_HID_PROP_CURSORTYPE"
#define HID_PROP_READONLY                               "EXTENSIONS_HID_PROP_READONLY"
#define HID_PROP_DATAENTRY                              "EXTENSIONS_HID_PROP_DATAENTRY"
#define HID_PROP_NAVIGATION                             "EXTENSIONS_HID_PROP_NAVIGATION"
#define HID_PROP_CYCLE                                  "EXTENSIONS_HID_PROP_CYCLE"
#define HID_PROP_ALLOW_ADDITIONS                        "EXTENSIONS_HID_PROP_ALLOW_ADDITIONS"
#define HID_PROP_ALLOW_EDITS                            "EXTENSIONS_HID_PROP_ALLOW_EDITS"
#define HID_PROP_ALLOW_DELETIONS                        "EXTENSIONS_HID_PROP_ALLOW_DELETIONS"
#define HID_PROP_DIRTY                                  "EXTENSIONS_HID_PROP_DIRTY"
#define HID_PROP_OLDVALUE                               "EXTENSIONS_HID_PROP_OLDVALUE"
#define HID_PROP_VALUE                                  "EXTENSIONS_HID_PROP_VALUE"
#define HID_PROP_LOCKED                                 "EXTENSIONS_HID_PROP_LOCKED"
#define HID_PROP_FORMATKEY                              "EXTENSIONS_HID_PROP_FORMATKEY"
#define HID_PROP_REQUIRED                               "EXTENSIONS_HID_PROP_REQUIRED"
#define HID_PROP_WHEEL_BEHAVIOR                         "EXTENSIONS_HID_PROP_WHEEL_BEHAVIOR"
#define HID_PROP_UNIQUE                                 "EXTENSIONS_HID_PROP_UNIQUE"
#define HID_PROP_CLASSID                                "EXTENSIONS_HID_PROP_CLASSID"
#define HID_PROP_LEFT                                   "EXTENSIONS_HID_PROP_LEFT"
#define HID_PROP_RIGHT                                  "EXTENSIONS_HID_PROP_RIGHT"
#define HID_PROP_HEIGHT                                 "EXTENSIONS_HID_PROP_HEIGHT"
#define HID_PROP_WIDTH                                  "EXTENSIONS_HID_PROP_WIDTH"
#define HID_PROP_BOUNDCOLUMN                            "EXTENSIONS_HID_PROP_BOUNDCOLUMN"
#define HID_PROP_LISTSOURCETYPE                         "EXTENSIONS_HID_PROP_LISTSOURCETYPE"
#define HID_PROP_LISTSOURCE                             "EXTENSIONS_HID_PROP_LISTSOURCE"
#define HID_PROP_LISTINDEX                              "EXTENSIONS_HID_PROP_LISTINDEX"
#define HID_PROP_TEXT                                   "EXTENSIONS_HID_PROP_TEXT"
#define HID_PROP_LABEL                                  "EXTENSIONS_HID_PROP_LABEL"
#define HID_PROP_STRINGITEMLIST                         "EXTENSIONS_HID_PROP_STRINGITEMLIST"
#define HID_PROP_SEARCHING                              "EXTENSIONS_HID_PROP_SEARCHING"
#define HID_PROP_FONT                                   "EXTENSIONS_HID_PROP_FONT"
#define HID_PROP_ROWHEIGHT                              "EXTENSIONS_HID_PROP_ROWHEIGHT"
#define HID_PROP_BACKGROUNDCOLOR                        "EXTENSIONS_HID_PROP_BACKGROUNDCOLOR"
#define HID_PROP_FILLCOLOR                              "EXTENSIONS_HID_PROP_FILLCOLOR"
#define HID_PROP_LINECOLOR                              "EXTENSIONS_HID_PROP_LINECOLOR"
#define HID_PROP_BORDER                                 "EXTENSIONS_HID_PROP_BORDER"
#define HID_PROP_ALIGN                                  "EXTENSIONS_HID_PROP_ALIGN"
#define HID_PROP_VERTICAL_ALIGN                         "EXTENSIONS_HID_PROP_VERTICAL_ALIGN"
#define HID_PROP_DROPDOWN                               "EXTENSIONS_HID_PROP_DROPDOWN"
#define HID_PROP_MULTILINE                              "EXTENSIONS_HID_PROP_MULTILINE"
#define HID_PROP_HSCROLL                                "EXTENSIONS_HID_PROP_HSCROLL"
#define HID_PROP_VSCROLL                                "EXTENSIONS_HID_PROP_VSCROLL"
#define HID_PROP_TABSTOP                                "EXTENSIONS_HID_PROP_TABSTOP"
#define HID_PROP_REFVALUE                               "EXTENSIONS_HID_PROP_REFVALUE"
#define HID_PROP_BUTTONTYPE                             "EXTENSIONS_HID_PROP_BUTTONTYPE"
#define HID_PROP_SUBMIT_ACTION                          "EXTENSIONS_HID_PROP_SUBMIT_ACTION"
#define HID_PROP_SUBMIT_METHOD                          "EXTENSIONS_HID_PROP_SUBMIT_METHOD"
#define HID_PROP_SUBMIT_ENCODING                        "EXTENSIONS_HID_PROP_SUBMIT_ENCODING"
#define HID_PROP_DEFAULTVALUE                           "EXTENSIONS_HID_PROP_DEFAULTVALUE"
#define HID_PROP_SUBMIT_TARGET                          "EXTENSIONS_HID_PROP_SUBMIT_TARGET"
#define HID_PROP_DEFAULT_STATE                          "EXTENSIONS_HID_PROP_DEFAULT_STATE"
#define HID_PROP_IMAGE_URL                              "EXTENSIONS_HID_PROP_IMAGE_URL"
#define HID_PROP_DEFAULT_SELECT_SEQ                     "EXTENSIONS_HID_PROP_DEFAULT_SELECT_SEQ"
#define HID_PROP_MULTISELECTION                         "EXTENSIONS_HID_PROP_MULTISELECTION"
#define HID_PROP_DATE                                   "EXTENSIONS_HID_PROP_DATE"
#define HID_PROP_DATEMIN                                "EXTENSIONS_HID_PROP_DATEMIN"
#define HID_PROP_DATEMAX                                "EXTENSIONS_HID_PROP_DATEMAX"
#define HID_PROP_DATEFORMAT                             "EXTENSIONS_HID_PROP_DATEFORMAT"
#define HID_PROP_TIME                                   "EXTENSIONS_HID_PROP_TIME"
#define HID_PROP_TIMEMIN                                "EXTENSIONS_HID_PROP_TIMEMIN"
#define HID_PROP_TIMEMAX                                "EXTENSIONS_HID_PROP_TIMEMAX"
#define HID_PROP_TIMEFORMAT                             "EXTENSIONS_HID_PROP_TIMEFORMAT"
#define HID_PROP_VALUEMIN                               "EXTENSIONS_HID_PROP_VALUEMIN"
#define HID_PROP_VALUEMAX                               "EXTENSIONS_HID_PROP_VALUEMAX"
#define HID_PROP_VALUESTEP                              "EXTENSIONS_HID_PROP_VALUESTEP"
#define HID_PROP_CURRENCYSYMBOL                         "EXTENSIONS_HID_PROP_CURRENCYSYMBOL"
#define HID_PROP_EDITMASK                               "EXTENSIONS_HID_PROP_EDITMASK"
#define HID_PROP_LITERALMASK                            "EXTENSIONS_HID_PROP_LITERALMASK"
#define HID_PROP_ENABLED                                "EXTENSIONS_HID_PROP_ENABLED"
#define HID_PROP_AUTOCOMPLETE                           "EXTENSIONS_HID_PROP_AUTOCOMPLETE"
#define HID_PROP_LINECOUNT                              "EXTENSIONS_HID_PROP_LINECOUNT"
#define HID_PROP_MAXTEXTLEN                             "EXTENSIONS_HID_PROP_MAXTEXTLEN"
#define HID_PROP_SPIN                                   "EXTENSIONS_HID_PROP_SPIN"
#define HID_PROP_STRICTFORMAT                           "EXTENSIONS_HID_PROP_STRICTFORMAT"
#define HID_PROP_SHOWTHOUSANDSEP                        "EXTENSIONS_HID_PROP_SHOWTHOUSANDSEP"
#define HID_PROP_VERTICAL_ALIGN                         "EXTENSIONS_HID_PROP_VERTICAL_ALIGN"
#define HID_PROP_PRINTABLE                              "EXTENSIONS_HID_PROP_PRINTABLE"
#define HID_PROP_TARGET_URL                             "EXTENSIONS_HID_PROP_TARGET_URL"
#define HID_PROP_TARGET_FRAME                           "EXTENSIONS_HID_PROP_TARGET_FRAME"
#define HID_PROP_TAG                                    "EXTENSIONS_HID_PROP_TAG"
#define HID_PROP_ECHO_CHAR                              "EXTENSIONS_HID_PROP_ECHO_CHAR"
#define HID_PROP_EMPTY_IS_NULL                          "EXTENSIONS_HID_PROP_EMPTY_IS_NULL"
#define HID_PROP_DECIMAL_ACCURACY                       "EXTENSIONS_HID_PROP_DECIMAL_ACCURACY"
#define HID_PROP_ENABLE_VISIBLE                         "EXTENSIONS_HID_PROP_ENABLE_VISIBLE"
#define HID_PROP_DEFAULT_BUTTON                         "EXTENSIONS_HID_PROP_DEFAULT_BUTTON"
#define HID_PROP_HIDDEN_VALUE                           "EXTENSIONS_HID_PROP_HIDDEN_VALUE"
#define HID_PROP_TRISTATE                               "EXTENSIONS_HID_PROP_TRISTATE"
#define HID_PROP_NAVIGATIONBAR                          "EXTENSIONS_HID_PROP_NAVIGATIONBAR"
#define HID_PROP_FILTER                                 "EXTENSIONS_HID_PROP_FILTER"
#define HID_PROP_SORT_CRITERIA                          "EXTENSIONS_HID_PROP_SORT_CRITERIA"
#define HID_PROP_DEFAULT_LONG_VALUE                     "EXTENSIONS_HID_PROP_DEFAULT_LONG_VALUE"
#define HID_PROP_DEFAULT_TIME                           "EXTENSIONS_HID_PROP_DEFAULT_TIME"
#define HID_PROP_DEFAULT_DATE                           "EXTENSIONS_HID_PROP_DEFAULT_DATE"
#define HID_PROP_HELPTEXT                               "EXTENSIONS_HID_PROP_HELPTEXT"
#define HID_PROP_HELPURL                                "EXTENSIONS_HID_PROP_HELPURL"
#define HID_PROP_RECORDMARKER                           "EXTENSIONS_HID_PROP_RECORDMARKER"
#define HID_PROP_FILTERPROPOSAL                         "EXTENSIONS_HID_PROP_FILTERPROPOSAL"
#define HID_PROP_EFFECTIVEMIN                           "EXTENSIONS_HID_PROP_EFFECTIVEMIN"
#define HID_PROP_EFFECTIVEMAX                           "EXTENSIONS_HID_PROP_EFFECTIVEMAX"
#define HID_PROP_EFFECTIVEDEFAULT                       "EXTENSIONS_HID_PROP_EFFECTIVEDEFAULT"
#define HID_PROP_CONTROLLABEL                           "EXTENSIONS_HID_PROP_CONTROLLABEL"
#define HID_PROP_CURRSYM_POSITION                       "EXTENSIONS_HID_PROP_CURRSYM_POSITION"
#define HID_PROP_ESCAPE_PROCESSING                      "EXTENSIONS_HID_PROP_ESCAPE_PROCESSING"
#define HID_PROP_TITLE                                  "EXTENSIONS_HID_PROP_TITLE"
#define HID_PROP_STEP                                   "EXTENSIONS_HID_PROP_STEP"
#define HID_PROP_PROGRESSVALUE                          "EXTENSIONS_HID_PROP_PROGRESSVALUE"
#define HID_PROP_PROGRESSVALUE_MIN                      "EXTENSIONS_HID_PROP_PROGRESSVALUE_MIN"
#define HID_PROP_PROGRESSVALUE_MAX                      "EXTENSIONS_HID_PROP_PROGRESSVALUE_MAX"
#define HID_PROP_SCROLLVALUE                            "EXTENSIONS_HID_PROP_SCROLLVALUE"
#define HID_PROP_SCROLLVALUE_MAX                        "EXTENSIONS_HID_PROP_SCROLLVALUE_MAX"
#define HID_PROP_SCROLL_WIDTH                           "EXTENSIONS_HID_PROP_SCROLL_WIDTH"
#define HID_PROP_SCROLL_HEIGHT                          "EXTENSIONS_HID_PROP_SCROLL_HEIGHT"
#define HID_PROP_SCROLL_TOP                             "EXTENSIONS_HID_PROP_SCROLL_TOP"
#define HID_PROP_SCROLL_LEFT                            "EXTENSIONS_HID_PROP_SCROLL_LEFT"
#define HID_PROP_LINEINCREMENT                          "EXTENSIONS_HID_PROP_LINEINCREMENT"
#define HID_PROP_BLOCKINCREMENT                         "EXTENSIONS_HID_PROP_BLOCKINCREMENT"
#define HID_PROP_VISIBLESIZE                            "EXTENSIONS_HID_PROP_VISIBLESIZE"
#define HID_PROP_ORIENTATION                            "EXTENSIONS_HID_PROP_ORIENTATION"
#define HID_PROP_POSITIONX                              "EXTENSIONS_HID_PROP_POSITIONX"
#define HID_PROP_POSITIONY                              "EXTENSIONS_HID_PROP_POSITIONY"
#define HID_PROP_PUSHBUTTONTYPE                         "EXTENSIONS_HID_PROP_PUSHBUTTONTYPE"
#define HID_PROP_STATE                                  "EXTENSIONS_HID_PROP_STATE"
#define HID_PROP_SCALEIMAGE                             "EXTENSIONS_HID_PROP_SCALEIMAGE"
#define HID_PROP_BOUND_CELL                             "EXTENSIONS_HID_PROP_BOUND_CELL"
#define HID_PROP_LIST_CELL_RANGE                        "EXTENSIONS_HID_PROP_LIST_CELL_RANGE"
#define HID_PROP_CELL_EXCHANGE_TYPE                     "EXTENSIONS_HID_PROP_CELL_EXCHANGE_TYPE"
#define HID_PROP_SELECTEDITEMS                          "EXTENSIONS_HID_PROP_SELECTEDITEMS"
#define HID_PROP_SCROLLVALUE_MIN                        "EXTENSIONS_HID_PROP_SCROLLVALUE_MIN"
#define HID_PROP_DEFAULT_SCROLLVALUE                    "EXTENSIONS_HID_PROP_DEFAULT_SCROLLVALUE"
#define HID_PROP_REPEAT_DELAY                           "EXTENSIONS_HID_PROP_REPEAT_DELAY"
#define HID_PROP_SYMBOLCOLOR                            "EXTENSIONS_HID_PROP_SYMBOLCOLOR"
#define HID_PROP_SPINVALUE                              "EXTENSIONS_HID_PROP_SPINVALUE"
#define HID_PROP_SPINVALUE_MIN                          "EXTENSIONS_HID_PROP_SPINVALUE_MIN"
#define HID_PROP_SPINVALUE_MAX                          "EXTENSIONS_HID_PROP_SPINVALUE_MAX"
#define HID_PROP_DEFAULT_SPINVALUE                      "EXTENSIONS_HID_PROP_DEFAULT_SPINVALUE"
#define HID_PROP_SPININCREMENT                          "EXTENSIONS_HID_PROP_SPININCREMENT"
#define HID_PROP_REPEAT                                 "EXTENSIONS_HID_PROP_REPEAT"
#define HID_PROP_WORDBREAK                              "EXTENSIONS_HID_PROP_WORDBREAK"
#define HID_PROP_SHOW_SCROLLBARS                        "EXTENSIONS_HID_PROP_SHOW_SCROLLBARS"
#define HID_PROP_ICONSIZE                               "EXTENSIONS_HID_PROP_ICONSIZE"
#define HID_PROP_SHOW_POSITION                          "EXTENSIONS_HID_PROP_SHOW_POSITION"
#define HID_PROP_SHOW_NAVIGATION                        "EXTENSIONS_HID_PROP_SHOW_NAVIGATION"
#define HID_PROP_SHOW_RECORDACTIONS                     "EXTENSIONS_HID_PROP_SHOW_RECORDACTIONS"
#define HID_PROP_SHOW_FILTERSORT                        "EXTENSIONS_HID_PROP_SHOW_FILTERSORT"
#define HID_PROP_AUTOLINEBREAK                          "EXTENSIONS_HID_PROP_AUTOLINEBREAK"
#define HID_PROP_TEXTTYPE                               "EXTENSIONS_HID_PROP_TEXTTYPE"
#define HID_PROP_LINEEND_FORMAT                         "EXTENSIONS_HID_PROP_LINEEND_FORMAT"
#define HID_PROP_XSD_TOTAL_DIGITS                       "EXTENSIONS_HID_PROP_XSD_TOTAL_DIGITS"
#define HID_PROP_XSD_FRACTION_DIGITS                    "EXTENSIONS_HID_PROP_XSD_FRACTION_DIGITS"
#define HID_PROP_XSD_MAX_INCLUSIVE                      "EXTENSIONS_HID_PROP_XSD_MAX_INCLUSIVE"
#define HID_PROP_XSD_MAX_EXCLUSIVE                      "EXTENSIONS_HID_PROP_XSD_MAX_EXCLUSIVE"
#define HID_PROP_XSD_MIN_INCLUSIVE                      "EXTENSIONS_HID_PROP_XSD_MIN_INCLUSIVE"
#define HID_PROP_XSD_MIN_EXCLUSIVE                      "EXTENSIONS_HID_PROP_XSD_MIN_EXCLUSIVE"
#define HID_PROP_UNCHECKEDREFVALUE                      "EXTENSIONS_HID_PROP_UNCHECKEDREFVALUE"
#define HID_PROP_SUBMISSION_ID                          "EXTENSIONS_HID_PROP_SUBMISSION_ID"
#define HID_PROP_XML_DATA_MODEL                         "EXTENSIONS_HID_PROP_XML_DATA_MODEL"
#define HID_PROP_BIND_EXPRESSION                        "EXTENSIONS_HID_PROP_BIND_EXPRESSION"
#define HID_PROP_XSD_REQUIRED                           "EXTENSIONS_HID_PROP_XSD_REQUIRED"
#define HID_PROP_XSD_RELEVANT                           "EXTENSIONS_HID_PROP_XSD_RELEVANT"
#define HID_PROP_XSD_READONLY                           "EXTENSIONS_HID_PROP_XSD_READONLY"
#define HID_PROP_XSD_CONSTRAINT                         "EXTENSIONS_HID_PROP_XSD_CONSTRAINT"
#define HID_PROP_XSD_CALCULATION                        "EXTENSIONS_HID_PROP_XSD_CALCULATION"
#define HID_PROP_XSD_DATA_TYPE                          "EXTENSIONS_HID_PROP_XSD_DATA_TYPE"
#define HID_PROP_XSD_WHITESPACES                        "EXTENSIONS_HID_PROP_XSD_WHITESPACES"
#define HID_PROP_URL                                    "EXTENSIONS_HID_PROP_URL"
#define HID_PROP_XSD_PATTERN                            "EXTENSIONS_HID_PROP_XSD_PATTERN"
#define HID_PROP_XSD_LENGTH                             "EXTENSIONS_HID_PROP_XSD_LENGTH"
#define HID_PROP_XSD_MIN_LENGTH                         "EXTENSIONS_HID_PROP_XSD_MIN_LENGTH"
#define HID_PROP_XSD_MAX_LENGTH                         "EXTENSIONS_HID_PROP_XSD_MAX_LENGTH"
#define HID_PROP_LIST_BINDING                           "EXTENSIONS_HID_PROP_LIST_BINDING"
#define HID_PROP_BINDING_NAME                           "EXTENSIONS_HID_PROP_BINDING_NAME"
#define HID_PROP_SELECTION_TYPE                         "EXTENSIONS_HID_PROP_SELECTION_TYPE"
#define HID_PROP_ROOT_DISPLAYED                         "EXTENSIONS_HID_PROP_ROOT_DISPLAYED"
#define HID_PROP_SHOWS_HANDLES                          "EXTENSIONS_HID_PROP_SHOWS_HANDLES"
#define HID_PROP_SHOWS_ROOT_HANDLES                     "EXTENSIONS_HID_PROP_SHOWS_ROOT_HANDLES"
#define HID_PROP_EDITABLE                               "EXTENSIONS_HID_PROP_EDITABLE"
#define HID_PROP_INVOKES_STOP_NOT_EDITING               "EXTENSIONS_HID_PROP_INVOKES_STOP_NOT_EDITING"
#define HID_PROP_ROW_HEIGHT                             "EXTENSIONS_HID_PROP_ROW_HEIGHT"
#define HID_PROP_DECORATION                             "EXTENSIONS_HID_PROP_DECORATION"
#define HID_EVT_ACTIONPERFORMED                         "EXTENSIONS_HID_EVT_ACTIONPERFORMED"
#define HID_EVT_AFTERUPDATE                             "EXTENSIONS_HID_EVT_AFTERUPDATE"
#define HID_EVT_BEFOREUPDATE                            "EXTENSIONS_HID_EVT_BEFOREUPDATE"
#define HID_EVT_CONFIRMDELETE                           "EXTENSIONS_HID_EVT_CONFIRMDELETE"
#define HID_EVT_ERROROCCURRED                           "EXTENSIONS_HID_EVT_ERROROCCURRED"
#define HID_EVT_FOCUSGAINED                             "EXTENSIONS_HID_EVT_FOCUSGAINED"
#define HID_EVT_FOCUSLOST                               "EXTENSIONS_HID_EVT_FOCUSLOST"
#define HID_EVT_ITEMSTATECHANGED                        "EXTENSIONS_HID_EVT_ITEMSTATECHANGED"
#define HID_EVT_KEYTYPED                                "EXTENSIONS_HID_EVT_KEYTYPED"
#define HID_EVT_LOADED                                  "EXTENSIONS_HID_EVT_LOADED"
#define HID_EVT_MOUSEDRAGGED                            "EXTENSIONS_HID_EVT_MOUSEDRAGGED"
#define HID_EVT_MOUSEENTERED                            "EXTENSIONS_HID_EVT_MOUSEENTERED"
#define HID_EVT_MOUSEEXITED                             "EXTENSIONS_HID_EVT_MOUSEEXITED"
#define HID_EVT_MOUSEMOVED                              "EXTENSIONS_HID_EVT_MOUSEMOVED"
#define HID_EVT_MOUSEPRESSED                            "EXTENSIONS_HID_EVT_MOUSEPRESSED"
#define HID_EVT_MOUSERELEASED                           "EXTENSIONS_HID_EVT_MOUSERELEASED"
#define HID_EVT_POSITIONED                              "EXTENSIONS_HID_EVT_POSITIONED"
#define HID_EVT_RESETTED                                "EXTENSIONS_HID_EVT_RESETTED"
#define HID_EVT_SUBMITTED                               "EXTENSIONS_HID_EVT_SUBMITTED"
#define HID_EVT_TEXTCHANGED                             "EXTENSIONS_HID_EVT_TEXTCHANGED"
#define HID_EVT_UNLOADED                                "EXTENSIONS_HID_EVT_UNLOADED"
#define HID_EVT_CHANGED                                 "EXTENSIONS_HID_EVT_CHANGED"
#define HID_EVT_APPROVEACTIONPERFORMED                  "EXTENSIONS_HID_EVT_APPROVEACTIONPERFORMED"
#define HID_EVT_APPROVERESETTED                         "EXTENSIONS_HID_EVT_APPROVERESETTED"
#define HID_EVT_KEYUP                                   "EXTENSIONS_HID_EVT_KEYUP"
#define HID_EVT_APPROVEPARAMETER                        "EXTENSIONS_HID_EVT_APPROVEPARAMETER"
#define HID_EVT_POSITIONING                             "EXTENSIONS_HID_EVT_POSITIONING"
#define HID_EVT_RELOADED                                "EXTENSIONS_HID_EVT_RELOADED"
#define HID_EVT_APPROVEROWCHANGE                        "EXTENSIONS_HID_EVT_APPROVEROWCHANGE"
#define HID_EVT_ROWCHANGE                               "EXTENSIONS_HID_EVT_ROWCHANGE"
#define HID_EVT_RELOADING                               "EXTENSIONS_HID_EVT_RELOADING"
#define HID_EVT_UNLOADING                               "EXTENSIONS_HID_EVT_UNLOADING"
#define HID_EVT_ADJUSTMENTVALUECHANGED                  "EXTENSIONS_HID_EVT_ADJUSTMENTVALUECHANGED"
#define HID_PROP_TOGGLE                                 "EXTENSIONS_HID_PROP_TOGGLE"
#define HID_PROP_FOCUSONCLICK                           "EXTENSIONS_HID_PROP_FOCUSONCLICK"
#define HID_PROP_HIDEINACTIVESELECTION                  "EXTENSIONS_HID_PROP_HIDEINACTIVESELECTION"
#define HID_PROP_VISUALEFFECT                           "EXTENSIONS_HID_PROP_VISUALEFFECT"
#define HID_PROP_BORDERCOLOR                            "EXTENSIONS_HID_PROP_BORDERCOLOR"
#define HID_PROP_IMAGEPOSITION                          "EXTENSIONS_HID_PROP_IMAGEPOSITION"
#define HID_PROP_NOLABEL                                "EXTENSIONS_HID_PROP_NOLABEL"
#define HID_PROP_WRITING_MODE                           "EXTENSIONS_HID_PROP_WRITING_MODE"
#define HID_PROP_ANCHOR_TYPE                            "EXTENSIONS_HID_PROP_ANCHOR_TYPE"
#define HID_FM_PROPDLG_TABCTR                           "EXTENSIONS_HID_FM_PROPDLG_TABCTR"
#define HID_FM_PROPDLG_TAB_GENERAL                      "EXTENSIONS_HID_FM_PROPDLG_TAB_GENERAL"
#define HID_FM_PROPDLG_TAB_DATA                         "EXTENSIONS_HID_FM_PROPDLG_TAB_DATA"
#define HID_FM_PROPDLG_TAB_EVT                          "EXTENSIONS_HID_FM_PROPDLG_TAB_EVT"
#define HID_PROP_GROUP_NAME                             "EXTENSIONS_HID_PROP_GROUP_NAME"

#define HID_PROP_SELECTIONMODEL                         "EXTENSIONS_HID_PROP_SELECTIONMODEL"
#define HID_PROP_USEGRIDLINE                            "EXTENSIONS_HID_PROP_USEGRIDLINE"
#define HID_PROP_GRIDLINECOLOR                          "EXTENSIONS_HID_PROP_GRIDLINECOLOR"
#define HID_PROP_SHOWCOLUMNHEADER                       "EXTENSIONS_HID_PROP_SHOWCOLUMNHEADER"
#define HID_PROP_SHOWROWHEADER                          "EXTENSIONS_HID_PROP_SHOWROWHEADER"
#define HID_PROP_HEADERBACKGROUNDCOLOR                  "EXTENSIONS_HID_PROP_HEADERBACKGROUNDCOLOR"
#define HID_PROP_HEADERTEXTCOLOR                        "EXTENSIONS_HID_PROP_HEADERTEXTCOLOR"
#define HID_PROP_ACTIVESELECTIONBACKGROUNDCOLOR         "EXTENSIONS_HID_PROP_ACTIVESELECTIONBACKGROUNDCOLOR"
#define HID_PROP_ACTIVESELECTIONTEXTCOLOR               "EXTENSIONS_HID_PROP_ACTIVESELECTIONTEXTCOLOR"
#define HID_PROP_INACTIVESELECTIONBACKGROUNDCOLOR       "EXTENSIONS_HID_PROP_INACTIVESELECTIONBACKGROUNDCOLOR"
#define HID_PROP_INACTIVESELECTIONTEXTCOLOR             "EXTENSIONS_HID_PROP_INACTIVESELECTIONTEXTCOLOR"

#define HID_CHECK_FOR_UPD_DLG                           "EXTENSIONS_HID_CHECK_FOR_UPD_DLG"
#define HID_CHECK_FOR_UPD_CLOSE                         "EXTENSIONS_HID_CHECK_FOR_UPD_CLOSE"
#define HID_CHECK_FOR_UPD_PAUSE                         "EXTENSIONS_HID_CHECK_FOR_UPD_PAUSE"
#define HID_CHECK_FOR_UPD_RESUME                        "EXTENSIONS_HID_CHECK_FOR_UPD_RESUME"
#define HID_CHECK_FOR_UPD_DOWNLOAD                      "EXTENSIONS_HID_CHECK_FOR_UPD_DOWNLOAD"
#define HID_CHECK_FOR_UPD_DOWNLOAD2                     "EXTENSIONS_HID_CHECK_FOR_UPD_DOWNLOAD2"
#define HID_CHECK_FOR_UPD_INSTALL                       "EXTENSIONS_HID_CHECK_FOR_UPD_INSTALL"
#define HID_CHECK_FOR_UPD_STATUS                        "EXTENSIONS_HID_CHECK_FOR_UPD_STATUS"
#define HID_CHECK_FOR_UPD_DESCRIPTION                   "EXTENSIONS_HID_CHECK_FOR_UPD_DESCRIPTION"
#define HID_CHECK_FOR_UPD_CANCEL                        "EXTENSIONS_HID_CHECK_FOR_UPD_CANCEL"

#endif // EXTENSIONS_ABPILOT_HRC

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
