/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4; fill-column: 100 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/** Those are the starmath codes for ElementsDockingWindow.hxx.
  *
  * Those codes will be displayed as formulas on the ElementsDockingWindow.
  * The user can then graphically insert them.
  */

#pragma once

#include <rtl/ustring.hxx>

inline constexpr OUStringLiteral RID_UNDOFORMATNAME = u"Format";

// clang-format off
#define RID_PLUSX               "+<?> "
#define RID_MINUSX              "-<?> "
#define RID_PLUSMINUSX          "+-<?> "
#define RID_MINUSPLUSX          "-+<?> "
#define RID_NEGX                "neg <?> "
#define RID_XPLUSY              "<?> + <?> "
#define RID_XMINUSY             "<?> - <?> "
#define RID_XCDOTY              "<?> cdot <?> "
#define RID_XTIMESY             "<?> times <?> "
#define RID_XSYMTIMESY          "<?> * <?> "
#define RID_XSYMDIVIDEY         "<?> / <?> "
#define RID_XDIVY               "<?> div <?> "
#define RID_XOVERY              "{<?>} over {<?>} "
#define RID_FRACXY              "frac {<?>} {<?>} "
#define RID_XODIVIDEY           "<?> odivide <?> "
#define RID_XODOTY              "<?> odot <?> "
#define RID_XOMINUSY            "<?> ominus <?> "
#define RID_XOPLUSY             "<?> oplus <?> "
#define RID_XOTIMESY            "<?> otimes <?> "
#define RID_XANDY               "<?> and <?> "
#define RID_XORY                "<?> or <?> "
#define RID_XEQY                "<?> = <?> "
#define RID_XNEQY               "<?> <> <?> "
#define RID_XLTY                "<?> < <?> "
#define RID_XGTY                "<?> > <?> "
#define RID_XLEY                "<?> <= <?> "
#define RID_XGEY                "<?> >= <?> "
#define RID_XLESLANTY           "<?> leslant <?> "
#define RID_XGESLANTY           "<?> geslant <?> "
#define RID_XLLY                "<?> << <?> "
#define RID_XGGY                "<?> >> <?> "
#define RID_XDEFY               "<?> def <?> "
#define RID_XEQUIVY             "<?> equiv <?> "
#define RID_XAPPROXY            "<?> approx <?> "
#define RID_XSIMY               "<?> sim <?> "
#define RID_XSIMEQY             "<?> simeq <?> "
#define RID_XPROPY              "<?> prop <?> "
#define RID_XORTHOY             "<?> ortho <?> "
#define RID_XPARALLELY          "<?> parallel <?> "
#define RID_XTOWARDY            "<?> toward <?> "
#define RID_XTRANSLY            "<?> transl <?> "
#define RID_XTRANSRY            "<?> transr <?> "
#define RID_XINY                "<?> in <?> "
#define RID_XNOTINY             "<?> notin <?> "
#define RID_XOWNSY              "<?> owns <?> "
#define RID_XUNIONY             "<?> union <?> "
#define RID_XINTERSECTIONY      "<?> intersection <?> "
#define RID_XSETMINUSY          "<?> setminus <?> "
#define RID_XSETQUOTIENTY       "<?> setquotient <?> "
#define RID_XSUBSETY            "<?> subset <?> "
#define RID_XSUBSETEQY          "<?> subseteq <?> "
#define RID_XSUPSETY            "<?> supset <?> "
#define RID_XSUPSETEQY          "<?> supseteq <?> "
#define RID_XNSUBSETY           "<?> nsubset <?> "
#define RID_XNSUBSETEQY         "<?> nsubseteq <?> "
#define RID_XNSUPSETY           "<?> nsupset <?> "
#define RID_XNSUPSETEQY         "<?> nsupseteq <?> "
#define RID_FUNCX               "func <?>(<?>) "
#define RID_ABSX                "abs{<?>} "
#define RID_FACTX               "fact{<?>} "
#define RID_SQRTX               "sqrt{<?>} "
#define RID_NROOTXY             "nroot{<?>}{<?>} "
#define RID_EX                  "func e^{<?>} "
#define RID_EXPX                "exp(<?>) "
#define RID_LNX                 "ln(<?>) "
#define RID_LOGX                "log(<?>) "
#define RID_SINX                "sin(<?>) "
#define RID_COSX                "cos(<?>) "
#define RID_TANX                "tan(<?>) "
#define RID_COTX                "cot(<?>) "
#define RID_ARCSINX             "arcsin(<?>) "
#define RID_ARCCOSX             "arccos(<?>) "
#define RID_ARCTANX             "arctan(<?>) "
#define RID_ARCCOTX             "arccot(<?>) "
#define RID_SINHX               "sinh(<?>) "
#define RID_COSHX               "cosh(<?>) "
#define RID_TANHX               "tanh(<?>) "
#define RID_COTHX               "coth(<?>) "
#define RID_ARSINHX             "arsinh(<?>) "
#define RID_ARCOSHX             "arcosh(<?>) "
#define RID_ARTANHX             "artanh(<?>) "
#define RID_ARCOTHX             "arcoth(<?>) "
#define RID_OPERX               "oper oper <?> "
#define RID_OPER_FROMX          "oper oper from{<?>} <?> "
#define RID_OPER_TOX            "oper oper to{<?>} <?> "
#define RID_OPER_FROMTOX        "oper oper from{<?>} to{<?>} <?> "
#define RID_SUMX                "sum <?> "
#define RID_SUM_FROMX           "sum from{<?>} <?> "
#define RID_SUM_TOX             "sum to{<?>} <?> "
#define RID_SUM_FROMTOX         "sum from{<?>} to{<?>} <?> "
#define RID_PRODX               "prod <?> "
#define RID_PROD_FROMX          "prod from{<?>} <?> "
#define RID_PROD_TOX            "prod to{<?>} <?> "
#define RID_PROD_FROMTOX        "prod from{<?>} to{<?>} <?> "
#define RID_COPRODX             "coprod <?> "
#define RID_COPROD_FROMX        "coprod from{<?>} <?> "
#define RID_COPROD_TOX          "coprod to{<?>} <?> "
#define RID_COPROD_FROMTOX      "coprod from{<?>} to{<?>} <?> "
#define RID_LIMX                "lim <?> "
#define RID_LIM_FROMX           "lim from{<?>} <?> "
#define RID_LIM_TOX             "lim to{<?>} <?> "
#define RID_LIM_FROMTOX         "lim from{<?>} to{<?>} <?> "
#define RID_LIMINFX             "liminf <?> "
#define RID_LIMINF_FROMX        "liminf from{<?>} <?> "
#define RID_LIMINF_TOX          "liminf to{<?>} <?> "
#define RID_LIMINF_FROMTOX      "liminf from{<?>} to{<?>} <?> "
#define RID_LIMSUPX             "limsup <?> "
#define RID_LIMSUP_FROMX        "limsup from{<?>} <?> "
#define RID_LIMSUP_TOX          "limsup to{<?>} <?> "
#define RID_LIMSUP_FROMTOX      "limsup from{<?>} to{<?>} <?> "
#define RID_EXISTS              "exists "
#define RID_NOTEXISTS           "notexists "
#define RID_FORALL              "forall "
#define RID_INTX                "int <?> "
#define RID_INT_FROMX           "int from{<?>} <?> "
#define RID_INT_TOX             "int to{<?>} <?> "
#define RID_INT_FROMTOX         "int from{<?>} to{<?>} <?> "
#define RID_IINTX               "iint <?> "
#define RID_IINT_FROMX          "iint from{<?>} <?> "
#define RID_IINT_TOX            "iint to{<?>} <?> "
#define RID_IINT_FROMTOX        "iint from{<?>} to{<?>} <?> "
#define RID_IIINTX              "iiint <?> "
#define RID_IIINT_FROMX         "iiint from{<?>} <?> "
#define RID_IIINT_TOX           "iiint to{<?>} <?> "
#define RID_IIINT_FROMTOX       "iiint from{<?>} to{<?>} <?> "
#define RID_LINTX               "lint <?> "
#define RID_LINT_FROMX          "lint from{<?>} <?> "
#define RID_LINT_TOX            "lint to{<?>} <?> "
#define RID_LINT_FROMTOX        "lint from{<?>} to{<?>} <?> "
#define RID_LLINTX              "llint <?> "
#define RID_LLINT_FROMX         "llint from{<?>} <?> "
#define RID_LLINT_TOX           "llint to{<?>} <?> "
#define RID_LLINT_FROMTOX       "llint from{<?>} to{<?>} <?> "
#define RID_LLLINTX             "lllint <?> "
#define RID_LLLINT_FROMX        "lllint from{<?>} <?> "
#define RID_LLLINT_TOX          "lllint to{<?>} <?> "
#define RID_LLLINT_FROMTOX      "lllint from{<?>} to{<?>} <?> "
#define RID_FROMX               "from{<?>} <?> "
#define RID_TOX                 "to{<?>} <?> "
#define RID_FROMXTOY            "from{<?>} to{<?>} <?> "
#define RID_ACUTEX              "acute <?> "
#define RID_BARX                "bar <?> "
#define RID_BREVEX              "breve <?> "
#define RID_CHECKX              "check <?> "
#define RID_CIRCLEX             "circle <?> "
#define RID_DOTX                "dot <?> "
#define RID_DDOTX               "ddot <?> "
#define RID_DDDOTX              "dddot <?> "
#define RID_GRAVEX              "grave <?> "
#define RID_HATX                "hat <?> "
#define RID_TILDEX              "tilde <?> "
#define RID_VECX                "vec <?> "
#define RID_HARPOONX            "harpoon <?> "
#define RID_UNDERLINEX          "underline {<?>} "
#define RID_OVERLINEX           "overline {<?>} "
#define RID_OVERSTRIKEX         "overstrike {<?>} "
#define RID_PHANTOMX            "phantom {<?>} "
#define RID_BOLDX               "bold <?> "
#define RID_ITALX               "ital <?> "
#define RID_SIZEXY              "size <?> {<?>} "
#define RID_FONTXY              "font <?> {<?>} "
#define RID_COLORX_BLACK        "color black {<?>} "
#define RID_COLORX_BLUE         "color blue {<?>} "
#define RID_COLORX_GREEN        "color green {<?>} "
#define RID_COLORX_RED          "color red {<?>} "
#define RID_COLORX_AQUA         "color aqua {<?>} "
#define RID_COLORX_FUCHSIA      "color fuchsia {<?>} "
#define RID_COLORX_GRAY         "color gray {<?>} "
#define RID_COLORX_LIME         "color lime {<?>} "
#define RID_COLORX_MAROON       "color maroon {<?>} "
#define RID_COLORX_NAVY         "color navy {<?>} "
#define RID_COLORX_OLIVE        "color olive {<?>} "
#define RID_COLORX_PURPLE       "color purple {<?>} "
#define RID_COLORX_SILVER       "color silver {<?>} "
#define RID_COLORX_TEAL         "color teal {<?>} "
#define RID_COLORX_YELLOW       "color yellow {<?>} "
#define RID_COLORX_RGB          "color rgb 0 0 0 {<?>} "
#define RID_COLORX_RGBA         "color rgba 0 0 0 0 {<?>} "
#define RID_COLORX_HEX          "color hex 000000 {<?>} "
#define RID_COLORX_CORAL        "color coral {<?>} "
#define RID_COLORX_CRIMSON      "color crimson {<?>} "
#define RID_COLORX_MIDNIGHT     "color midnightblue {<?>} "
#define RID_COLORX_VIOLET       "color violet {<?>} "
#define RID_COLORX_ORANGE       "color orange {<?>} "
#define RID_COLORX_ORANGERED    "color orangered {<?>} "
#define RID_COLORX_SEAGREEN     "color seagreen {<?>} "
#define RID_COLORX_INDIGO       "color indigo {<?>} "
#define RID_COLORX_HOTPINK      "color hotpink {<?>} "
#define RID_COLORX_LAVENDER     "color lavender {<?>} "
#define RID_COLORX_SNOW         "color snow {<?>} "
#define RID_LRGROUPX            "{<?>} "
#define RID_LRPARENTX           "(<?>) "
#define RID_LRBRACKETX          "[<?>] "
#define RID_LRDBRACKETX         "ldbracket <?> rdbracket "
#define RID_LRBRACEX            "lbrace <?> rbrace "
#define RID_LRANGLEX            "langle <?> rangle "
#define RID_LRCEILX             "lceil <?> rceil "
#define RID_LRFLOORX            "lfloor <?> rfloor "
#define RID_LRLINEX             "lline <?> rline "
#define RID_LRDLINEX            "ldline <?> rdline "
#define RID_LMRANGLEXY          "langle <?> mline <?> rangle "
#define RID_SLRPARENTX          "left ( <?> right ) "
#define RID_SLRBRACKETX         "left [ <?> right ] "
#define RID_SLRDBRACKETX        "left ldbracket <?> right rdbracket "
#define RID_SLRBRACEX           "left lbrace <?> right rbrace "
#define RID_SLRANGLEX           "left langle <?> right rangle "
#define RID_SLRCEILX            "left lceil <?> right rceil "
#define RID_SLRFLOORX           "left lfloor <?> right rfloor "
#define RID_SLRLINEX            "left lline <?> right rline "
#define RID_SLRDLINEX           "left ldline <?> right rdline "
#define RID_SLMRANGLEXY         "left langle <?> mline <?> right rangle "
#define RID_XOVERBRACEY         "{<?>} overbrace {<?>} "
#define RID_XUNDERBRACEY        "{<?>} underbrace {<?>} "
#define RID_EVALX               "evaluate <?> "
#define RID_EVAL_FROMX          "evaluate {<?>} from{<?>} "
#define RID_EVAL_TOX            "evaluate {<?>} to{<?>} "
#define RID_EVAL_FROMTOX        "evaluate {<?>} from{<?>} to{<?>} "
#define RID_RSUBX               "<?>_{<?>} "
#define RID_RSUPX               "<?>^{<?>} "
#define RID_LSUBX               "<?> lsub{<?>} "
#define RID_LSUPX               "<?> lsup{<?>} "
#define RID_CSUBX               "<?> csub{<?>} "
#define RID_CSUPX               "<?> csup{<?>} "
#define RID_SBLANK              "` "
#define RID_BLANK               "~ "
#define RID_NEWLINE             "newline "
#define RID_BINOMXY             "binom{<?>}{<?>} "
#define RID_STACK               "stack{<?> # <?> # <?>} "
#define RID_MATRIX              "matrix{<?> # <?> ## <?> # <?>} "
#define RID_ALIGNLX             "alignl <?> "
#define RID_ALIGNCX             "alignc <?> "
#define RID_ALIGNRX             "alignr <?> "
#define RID_ALEPH               "aleph "
#define RID_EMPTYSET            "emptyset "
#define RID_RE                  "Re "
#define RID_IM                  "Im "
#define RID_INFINITY            "infinity "
#define RID_PARTIAL             "partial "
#define RID_NABLA               "nabla "
#define RID_WP                  "wp "
#define RID_LAPLACE             "laplace "
#define RID_BACKEPSILON         "backepsilon "
#define RID_FOURIER             "fourier "
#define RID_DOTSAXIS            "dotsaxis "
#define RID_DOTSUP              "dotsup "
#define RID_DOTSDOWN            "dotsdown "
#define RID_DOTSLOW             "dotslow "
#define RID_DOTSVERT            "dotsvert "
#define RID_XCIRCY              "<?> circ <?> "
#define RID_XWIDESLASHY         "{<?>} wideslash {<?>} "
#define RID_XWIDEBSLASHY        "{<?>} widebslash {<?>} "
#define RID_XDIVIDESY           "<?> divides <?> "
#define RID_XNDIVIDESY          "<?> ndivides <?> "
#define RID_DLARROW             "<?> dlarrow <?> "
#define RID_DLRARROW            "<?> dlrarrow <?> "
#define RID_DRARROW             "<?> drarrow <?> "
#define RID_SETN                "setN "
#define RID_SETZ                "setZ "
#define RID_SETQ                "setQ "
#define RID_SETR                "setR "
#define RID_SETC                "setC "
#define RID_WIDEHATX            "widehat {<?>} "
#define RID_WIDETILDEX          "widetilde {<?>} "
#define RID_WIDEVECX            "widevec {<?>} "
#define RID_WIDEHARPOONX        "wideharpoon {<?>} "
#define RID_HBAR                "hbar "
#define RID_LAMBDABAR           "lambdabar "
#define RID_LEFTARROW           "leftarrow "
#define RID_RIGHTARROW          "rightarrow "
#define RID_UPARROW             "uparrow "
#define RID_DOWNARROW           "downarrow "
#define RID_NOSPACE             "nospace {<?>} "
#define RID_XPRECEDESY          "<?> prec <?> "
#define RID_XPRECEDESEQUALY     "<?> preccurlyeq <?> "
#define RID_XPRECEDESEQUIVY     "<?> precsim <?> "
#define RID_XSUCCEEDSY          "<?> succ <?> "
#define RID_XSUCCEEDSEQUALY     "<?> succcurlyeq <?> "
#define RID_XSUCCEEDSEQUIVY     "<?> succsim <?> "
#define RID_XNOTPRECEDESY       "<?> nprec <?> "
#define RID_XNOTSUCCEEDSY       "<?> nsucc <?> "
// clang-format on

/* vim:set shiftwidth=4 softtabstop=4 expandtab cinoptions=b1,g0,N-s cinkeys+=0=break: */
