/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_DBACCESS_INC_HELPIDS_H
#define INCLUDED_DBACCESS_INC_HELPIDS_H

#include <rtl/ustring.hxx>

inline constexpr OUStringLiteral HID_DATABROWSE_HEADER = u"DBACCESS_HID_DATABROWSE_HEADER";
inline constexpr OUStringLiteral HID_CTL_TABBROWSER = u"DBACCESS_HID_CTL_TABBROWSER";
inline constexpr OUStringLiteral HID_CTL_TREEVIEW = u"DBACCESS_HID_CTL_TREEVIEW";

inline constexpr OUStringLiteral HID_DSADMIN_BROWSECONN = u"DBACCESS_HID_DSADMIN_BROWSECONN";

inline constexpr OUStringLiteral HID_CTL_QRYSQLEDIT = u"DBACCESS_HID_CTL_QRYSQLEDIT";

inline constexpr OUStringLiteral HID_CTL_QRYDGNTAB = u"DBACCESS_HID_CTL_QRYDGNTAB";
inline constexpr OUStringLiteral HID_CTL_QRYDGNCRIT = u"DBACCESS_HID_CTL_QRYDGNCRIT";
inline constexpr OUStringLiteral HID_QRYDGN_ROW_VISIBLE = u"DBACCESS_HID_QRYDGN_ROW_VISIBLE";
inline constexpr OUStringLiteral HID_QRYDGN_ROW_TABLE = u"DBACCESS_HID_QRYDGN_ROW_TABLE";
inline constexpr OUStringLiteral HID_QRYDGN_ROW_FIELD = u"DBACCESS_HID_QRYDGN_ROW_FIELD";
inline constexpr OUStringLiteral HID_QRYDGN_ROW_ORDER = u"DBACCESS_HID_QRYDGN_ROW_ORDER";
inline constexpr OUStringLiteral HID_QRYDGN_ROW_FUNCTION = u"DBACCESS_HID_QRYDGN_ROW_FUNCTION";
inline constexpr OUStringLiteral HID_QRYDGN_ROW_ALIAS = u"DBACCESS_HID_QRYDGN_ROW_ALIAS";
inline constexpr OUStringLiteral HID_QRYDGN_ROW_CRIT = u"DBACCESS_HID_QRYDGN_ROW_CRIT";

inline constexpr OUStringLiteral HID_TAB_DESIGN_FIELDCONTROL = u"DBACCESS_HID_TAB_DESIGN_FIELDCONTROL";
inline constexpr OUStringLiteral HID_TAB_DESIGN_DESCWIN = u"DBACCESS_HID_TAB_DESIGN_DESCWIN";
inline constexpr OUStringLiteral HID_TABDESIGN_BACKGROUND = u"DBACCESS_HID_TABDESIGN_BACKGROUND";
inline constexpr OUStringLiteral HID_CTL_TABLEEDIT = u"DBACCESS_HID_CTL_TABLEEDIT";
inline constexpr OUStringLiteral HID_TABDESIGN_NAMECELL = u"DBACCESS_HID_TABDESIGN_NAMECELL";
inline constexpr OUStringLiteral HID_TABDESIGN_TYPECELL = u"DBACCESS_HID_TABDESIGN_TYPECELL";
inline constexpr OUStringLiteral HID_TABDESIGN_COMMENTCELL = u"DBACCESS_HID_TABDESIGN_COMMENTCELL";
inline constexpr OUStringLiteral HID_TAB_DESIGN_HELP_TEXT_FRAME = u"DBACCESS_HID_TAB_DESIGN_HELP_TEXT_FRAME";
inline constexpr OUStringLiteral HID_TAB_ENT_DEFAULT = u"DBACCESS_HID_TAB_ENT_DEFAULT";
inline constexpr OUStringLiteral HID_TAB_ENT_FORMAT_SAMPLE = u"DBACCESS_HID_TAB_ENT_FORMAT_SAMPLE";
inline constexpr OUStringLiteral HID_TAB_ENT_FORMAT = u"DBACCESS_HID_TAB_ENT_FORMAT";
inline constexpr OUStringLiteral HID_TAB_ENT_BOOL_DEFAULT = u"DBACCESS_HID_TAB_ENT_BOOL_DEFAULT";
inline constexpr OUStringLiteral HID_TAB_ENT_REQUIRED = u"DBACCESS_HID_TAB_ENT_REQUIRED";
inline constexpr OUStringLiteral HID_TAB_ENT_AUTOINCREMENT = u"DBACCESS_HID_TAB_ENT_AUTOINCREMENT";
inline constexpr OUStringLiteral HID_TAB_ENT_TEXT_LEN = u"DBACCESS_HID_TAB_ENT_TEXT_LEN";
inline constexpr OUStringLiteral HID_TAB_ENT_TYPE = u"DBACCESS_HID_TAB_ENT_TYPE";
inline constexpr OUStringLiteral HID_TAB_ENT_COLUMNNAME = u"DBACCESS_HID_TAB_ENT_COLUMNNAME";
inline constexpr OUStringLiteral HID_TAB_ENT_NUMTYP = u"DBACCESS_HID_TAB_ENT_NUMTYP";
inline constexpr OUStringLiteral HID_TAB_ENT_LEN = u"DBACCESS_HID_TAB_ENT_LEN";
inline constexpr OUStringLiteral HID_TAB_ENT_SCALE = u"DBACCESS_HID_TAB_ENT_SCALE";
inline constexpr OUStringLiteral HID_CTL_RELATIONTAB = u"DBACCESS_HID_CTL_RELATIONTAB";
inline constexpr OUStringLiteral HID_RELATIONDIALOG_LEFTFIELDCELL = u"DBACCESS_HID_RELATIONDIALOG_LEFTFIELDCELL";
inline constexpr OUStringLiteral HID_RELATIONDIALOG_RIGHTFIELDCELL = u"DBACCESS_HID_RELATIONDIALOG_RIGHTFIELDCELL";
inline constexpr OUStringLiteral HID_CONFIRM_DROP_BUTTON_ALL = u"DBACCESS_HID_CONFIRM_DROP_BUTTON_ALL";
inline constexpr OUStringLiteral HID_DSADMIN_LDAP_HOSTNAME = u"DBACCESS_HID_DSADMIN_LDAP_HOSTNAME";
inline constexpr OUStringLiteral HID_DSADMIN_MOZILLA_PROFILE_NAME = u"DBACCESS_HID_DSADMIN_MOZILLA_PROFILE_NAME";
inline constexpr OUStringLiteral HID_DSADMIN_THUNDERBIRD_PROFILE_NAME = u"DBACCESS_HID_DSADMIN_THUNDERBIRD_PROFILE_NAME";

inline constexpr OUStringLiteral HID_DLGINDEX_INDEXDETAILS_FIELD = u"DBACCESS_HID_DLGINDEX_INDEXDETAILS_FIELD";
inline constexpr OUStringLiteral HID_DLGINDEX_INDEXDETAILS_SORTORDER = u"DBACCESS_HID_DLGINDEX_INDEXDETAILS_SORTORDER";

inline constexpr OUStringLiteral HID_TAB_AUTOINCREMENTVALUE = u"DBACCESS_HID_TAB_AUTOINCREMENTVALUE";

inline constexpr OUStringLiteral HID_DSADMIN_DBASE_PATH = u"DBACCESS_HID_DSADMIN_DBASE_PATH";
inline constexpr OUStringLiteral HID_DSADMIN_MYSQL_DATABASE = u"DBACCESS_HID_DSADMIN_MYSQL_DATABASE";
inline constexpr OUStringLiteral HID_DSADMIN_MYSQL_ODBC_DATASOURCE = u"DBACCESS_HID_DSADMIN_MYSQL_ODBC_DATASOURCE";
inline constexpr OUStringLiteral HID_DSADMIN_ODBC_DATASOURCE = u"DBACCESS_HID_DSADMIN_ODBC_DATASOURCE";
inline constexpr OUStringLiteral HID_DSADMIN_MSACCESS_MDB_FILE = u"DBACCESS_HID_DSADMIN_MSACCESS_MDB_FILE";
inline constexpr OUStringLiteral HID_DSADMIN_FLAT_PATH = u"DBACCESS_HID_DSADMIN_FLAT_PATH";
inline constexpr OUStringLiteral HID_DSADMIN_CALC_PATH = u"DBACCESS_HID_DSADMIN_CALC_PATH";
inline constexpr OUStringLiteral HID_DSADMIN_WRITER_PATH = u"DBACCESS_HID_DSADMIN_WRITER_PATH";
inline constexpr OUStringLiteral HID_DSADMIN_ORACLE_DATABASE = u"DBACCESS_HID_DSADMIN_ORACLE_DATABASE";

inline constexpr OUStringLiteral HID_APP_TABLE_TREE = u"DBACCESS_HID_APP_TABLE_TREE";
inline constexpr OUStringLiteral HID_APP_FORM_TREE = u"DBACCESS_HID_APP_FORM_TREE";
inline constexpr OUStringLiteral HID_APP_QUERY_TREE = u"DBACCESS_HID_APP_QUERY_TREE";
inline constexpr OUStringLiteral HID_APP_REPORT_TREE = u"DBACCESS_HID_APP_REPORT_TREE";
inline constexpr OUStringLiteral HID_APP_CREATION_LIST = u"DBACCESS_HID_APP_CREATION_LIST";
inline constexpr OUStringLiteral HID_APP_SWAP_ICONCONTROL = u"DBACCESS_HID_APP_SWAP_ICONCONTROL";


inline constexpr OUStringLiteral HID_APP_HELP_TEXT = u"DBACCESS_HID_APP_HELP_TEXT";
inline constexpr OUStringLiteral HID_APP_DESCRIPTION_TEXT = u"DBACCESS_HID_APP_DESCRIPTION_TEXT";
inline constexpr OUStringLiteral HID_APP_VIEW_PREVIEW_CB = u"DBACCESS_HID_APP_VIEW_PREVIEW_CB";
inline constexpr OUStringLiteral HID_APP_VIEW_PREVIEW_1 = u"DBACCESS_HID_APP_VIEW_PREVIEW_1";
inline constexpr OUStringLiteral HID_APP_VIEW_PREVIEW_2 = u"DBACCESS_HID_APP_VIEW_PREVIEW_2";
inline constexpr OUStringLiteral HID_TABDESIGN_HELPTEXT = u"DBACCESS_HID_TABDESIGN_HELPTEXT";
inline constexpr OUStringLiteral HID_APP_VIEW_PREVIEW_3 = u"DBACCESS_HID_APP_VIEW_PREVIEW_3";


inline constexpr OUStringLiteral HID_DBWIZ_PREVIOUS = u"DBACCESS_HID_DBWIZ_PREVIOUS";
inline constexpr OUStringLiteral HID_DBWIZ_NEXT = u"DBACCESS_HID_DBWIZ_NEXT";
inline constexpr OUStringLiteral HID_DBWIZ_CANCEL = u"DBACCESS_HID_DBWIZ_CANCEL";
inline constexpr OUStringLiteral HID_DBWIZ_FINISH = u"DBACCESS_HID_DBWIZ_FINISH";
inline constexpr OUStringLiteral HID_DBWIZ_HELP = u"DBACCESS_HID_DBWIZ_HELP";

inline constexpr OUStringLiteral HID_DBWIZ_ROADMAP = u"DBACCESS_HID_DBWIZ_ROADMAP";

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
